/******************************************************************************
 * (C) Copyright 2000 by Agilent Technologies GmbH. All rights reserved.      *
 ******************************************************************************/


/* ---------------------------------------------------------------
 * File: xladefs.h
 * -----------------------------------------------------------------*/

#ifndef XLADEFS_H_INCLUDED
#define XLADEFS_H_INCLUDED

#ifndef CLI
#define CLI
#endif


/* ---------------------------------------------------------------
 * Type Definitions for all signals available
 * --------------------------------------------------------------- */
CLI typedef enum {
  BX_SIG_AD64_2,
  BX_SIG_AD32_2,
  BX_SIG_AD64,
  BX_SIG_AD32,
  BX_SIG_FRAME,
  BX_SIG_IRDY,
  BX_SIG_TRDY,
  BX_SIG_DEVSEL,
  BX_SIG_IDSEL,
  BX_SIG_STOP,
  BX_SIG_REQ,
  BX_SIG_GNT,
  BX_SIG_PERR,
  BX_SIG_SERR,
  BX_SIG_PAR,
  BX_SIG_RST, 
  BX_SIG_INTA,
  BX_SIG_INTB,
  BX_SIG_INTC,
  BX_SIG_INTD,
  BX_SIG_CBE3_0,
  BX_SIG_CBE7_4,
  BX_SIG_LOCK,
  BX_SIG_PAR64,
  BX_SIG_REQ64,
  BX_SIG_ACK64,
  BX_SIG_trigio0,
  BX_SIG_trigio1,
  BX_SIG_trigio2,
  BX_SIG_trigio3,
  BX_SIG_bstate,
  BX_SIG_decode,
  BX_SIG_term,
  BX_SIG_xact_cmd,
  BX_SIG_xact_tran64,
  BX_SIG_ri_act,
  BX_SIG_ct_act,
  BX_SIG_ci_act,
  BX_SIG_rt_act,
  BX_SIG_ri_done,
  BX_SIG_proterr,
  BX_SIG_dcomperr,
  BX_SIG_spliterr,
  BX_SIG_c_rule0,
  BX_SIG_c_rule1,
  BX_SIG_c_rule2,
  BX_SIG_c_rule3,
  BX_SIG_ri_split_pending,
  BX_SIG_pcix_men,
  BX_SIG_ad_act,
  BX_SIG_gap,
  BX_SIG_gap_count,
  BX_SIG_addr_phase_occ,
  BX_SIG_NO_LABEL = 255
} bx_signaltype;

/*  c_rule2,3 no longer supported */
/*  BX_SIG_c_rule2,
    BX_SIG_c_rule3, */
/* These signals are not available in the trace memory but only 
   in the pattern terms. They are referenced only via the signal string
   not by bx_signaltype enum.
  BX_SIG_addr_phase,
  BX_SIG_xact_attr_ad,
  BX_SIG_xact_attr_cbe,
  BX_SIG_xact_dac,
  BX_SIG_xact_lock,
  BX_SIG_xact_trigio0,
  BX_SIG_xact_trigio1,
  BX_SIG_xact_trigio2,
  BX_SIG_xact_trigio3
*/
#ifndef SWIG
/*---------------------------------------------------------------------------*
 * typedef struct _bx_triginfo_type {
 *
 * Purpose: store some info about trigger point etc.
 *---------------------------------------------------------------------------*/
typedef struct _bx_triginfo_type {
  bx_int32 m_traceOffset;   /* offset of trace start into tracemem */
  bx_int32 m_triggerPoint;  /* trigger point rel. to trace start */
  bx_int32 m_linesCaptured; /* number of lines captured */
  bx_int32 m_memFull;       /* is trace mem completely full? */
} bx_triginfo_type;
#endif

#endif



